import { StyleSheet } from "react-native";
import dpr from "../Utilities/CustomStyleAttribute/dpr";

const cartStyle = StyleSheet.create({
    container: {
        backgroundColor: "#fff",
        minHeight: dpr("hwh"),
        paddingHorizontal: dpr(20),
        paddingBottom: dpr(290),
        paddingTop: dpr(15),
    },
    selectAllCont: (isCheckAll) => ({
        flexDirection: "row",
        justifyContent: "space-between",
        borderWidth: 1,
        marginBottom: dpr(15),
        borderColor: "#DFDFDF",
        borderRadius: 6,
        paddingHorizontal: dpr(10),
        paddingVertical: dpr(14),
        backgroundColor: isCheckAll ? '#FCCA19' : '#FFFFFF',
        width: dpr('wf') - dpr(40)
    }),
    deleteButton: {
        position: "absolute",
        right: dpr(2),
    },
    allItem: {
        width: '45%',
    },
    deleteAllCont: {
        flexDirection: "row",
        alignItems: "center",
    },

    allDlt: {
        width: '45%',
        justifyContent: 'flex-end'
    },
    deleteText: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(12),
        color: "#898989",
        marginHorizontal: dpr(8),
    },
    color: (isCheckAll) => ({
        color: isCheckAll ? '#2C2C2C' : '#898989',
    }),
    chechBox: {
        height: dpr(16),
        width: dpr(16),
    },
    items: {
        borderWidth: 1,
        borderColor: "#DFDFDF",
        borderRadius: 6,
        marginBottom: dpr(16),
    },
    itemsHeader: {
        flexDirection: "row",
        justifyContent: "space-between",
        backgroundColor: "#F3F3F3",
        paddingHorizontal: dpr(10),
        paddingVertical: dpr(14),
        borderTopLeftRadius: 6,
        borderTopRightRadius: 6,
    },
    sellerName: {
        fontSize: dpr(13),
        color: "#2C2C2C",
    },
    singleItemCont: {
        paddingHorizontal: dpr(10),
        marginTop: dpr(15),
        width: dpr("wf") - dpr(40),
    },
    singleItem: {
        flexDirection: "row",
    },
    itemLeftCont: {
        flexDirection: "row",
        alignItems: "center",
    },
    imgCont: {
        height: dpr(70),
        width: dpr(70),
        marginLeft: dpr(8),
        backgroundColor: "#F3F3F3",
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center",
        borderRadius: 4,
    },
    img: {
        height: dpr(45),
        width: dpr(45),
        borderRadius: 6,
    },
    itemRightCont: {
        flexDirection: "row",
        justifyContent: "space-between",
    },
    itemRightContAlign: {
        alignItems: "center"
    },
    itemInfo: {
        marginLeft: dpr(12),
        width: "75%",
    },
    itemName: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(12),
        color: "#2C2C2C",
        lineHeight: dpr(16),
    },
    itemNameSize: {
        fontSize: dpr(10),
        marginTop: dpr(4),
    },
    notAvailable: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(12),
        color: "#E43147",
    },
    itemSize: {
        fontFamily: "Roboto_500Medium",
        alignItems: "flex-start",
        fontSize: dpr(10),
        color: "#898989",
        marginTop: dpr(4),
    },
    qtyCont: {
        marginTop: dpr(7),
        flexDirection: "row",
        justifyContent: "space-between",
    },
    incDecCont: {
        flexDirection: "row",
        alignItems: "center",
    },
    incDec: {
        flexDirection: "row",
        alignItems: "center",
        justifyContent: "center",
        borderWidth: 1,
        borderColor: "#DFDFDF",
        width: dpr(70),
        height: dpr(30),
        marginLeft: dpr(8),
        borderRadius: 4,
    },
    inc: {
        height: dpr(30),
        width: dpr(33),
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center",
    },
    width: {
        width: 4
    },
    hr: {
        height: dpr(16),
        borderLeftWidth: 1,
        borderColor: "#DFDFDF",
    },
    qty: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(10),
        color: "#2C2C2C",
        marginLeft: dpr(12),
    },
    qtySize: {
        fontSize: dpr(12)
    },
    itemFooter: {
        flexDirection: "row",
        justifyContent: "space-between",
        paddingHorizontal: dpr(10),
        marginVertical: dpr(15),
        marginLeft: dpr(23),
    },
    footerText: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(12),
        color: "#2C2C2C",
    },
    checkoutCont: {
        flexDirection: "row",
        justifyContent: "space-between",
        alignItems: "center",
        position: "absolute",
        bottom: dpr(63),
        width: dpr("wf"),
        backgroundColor: "#2C2C2C",
        paddingHorizontal: dpr(20),
        paddingVertical: dpr(15),
    },
    totalPriceText: {
        fontFamily: "DMSans_700Bold",
        color: "#FFFFFF",
        fontSize: dpr(14),
        width: dpr("wf") / 2 - dpr(60),
        textAlign: "left",
    },
    totalPriceTextSize: {
        fontSize: dpr(20),
        marginTop: dpr(5),
    },
    proceedBtn: {
        backgroundColor: "#FCCA19",
        borderRadius: 6,
        paddingHorizontal: dpr(19),
        paddingVertical: dpr(13),
    },
    bg: (totalPrice) => ({
        backgroundColor: totalPrice ? '#FCCA19' : '#DFDFDF',
    }),
    proceedText: {
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(16),
        color: "#2C2C2C",
    },
    checkBoxSize: {
        height: dpr(16),
        width: dpr(16),
    },
});

export { cartStyle };
